//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//******************************************

//******************************************
//Stack Pointer	=	0x23f (If use mq6822_32PinPackage_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 
#include "iApp.h"
#include "OPmode.h"
#include "I2C.h"


void main()
{
	uchar iloop, data;
//----------------------------------------------------------------------//
//****** IO, CGCR and P10/P40/P41 initialization during debugging ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR and P10/P40/P41 initialization during debugging
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Please set the external crystal (HXTAL/LXTAL) from <OPmode.h> and refer to the following instructions:
//.....................................................................................
//#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//.....................................................................................
//	please change the above program in the <OPmode.h> file
//	please pay attention to the external crystal switching in this document
//--------------------------------------------------------------------------------------------------//

	__asm("DI");
	I2C_set();
	__asm("EI");
	delay_times(t_1ms, 1);

//	write sequence
if(1)
{
	I2C_start(0xa0);
	I2C_ByteWrite(0x00);
	// write data for program
	for( iloop=0; iloop<8; iloop++ )
	{
		data = iloop+0x60;
		I2C_ByteWrite(data);
	}
	I2C_stop();

	//...wait AT24C02 pgm time >5ms......................
	delay_times(t_1ms, 10);
}
//	read sequence
if(1)
{
	I2C_start(0xa0);
	I2C_ByteWrite(0x00);
	I2C_restart(0xa1);

	for( iloop=0; iloop<6; iloop++ )
		I2C_ByteRead();
	I2C_ByteRead_Last();

	I2C_stop();
}


	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
		__asm("CPL (_P9DR).0");
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}



